/*
 * Decompiled with CFR 0.152.
 */
package com.android.invoice.domain.use_case.invoice;

import com.android.invoice.domain.model.AInvoiceDtlDto;
import com.android.invoice.domain.use_case.invoice.FetchAInvoiceDetails;
import com.dto.LoginDto;
import com.service.SettingLoader;
import com.utility.CollectionBinder;
import com.utility.ConvertStr;
import com.utility.DbConnection;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Nullable;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Service;

@Service
class FetchAInvoiceDetails {
    private final DbConnection dbConnection;

    public List<AInvoiceDtlDto> invoke(LoginDto login, @Nullable List<String> invoiceIdList, Map<String, String> params) {
        SettingLoader settingLoader = new SettingLoader(this.dbConnection, login);
        String commaBoundResult = CollectionBinder.builder().build().wrapThenBind(invoiceIdList);
        String whereStr = (String)ConvertStr.ifElse((boolean)ConvertStr.isNullOrEmpty((String)commaBoundResult), () -> "", () -> " AND A.invoiceId IN (" + commaBoundResult + ") \n");
        String select = " SELECT fa.A_Code AS productCode, (S.M_groupcode + S.S_groupcode) AS productGroupCode, \n CAST(fa.IDFacture AS nvarchar(100)) AS invoiceId, IsNull(fa.A_Few, 0) AS amount, \n IsNull(fa.A_Price, 0) AS price, fa.ID AS serverId, fa.A_Comment AS description, \n IsNull(fa.A_Few2, 0) AS secondAmount, IsNull(fa.A_Few3, 0) AS thirdAmount, \n IsNull(fa.Unit_Code, -1) AS unitCode, IsNull(u.Unit_Few, 1) AS coefficient, \n IsNull(fa.DarsadTakhfif, 0) perRowDiscountPercent, \n IsNull(fa.TakhfifSatriR, 0) perRowDiscountAmount, \n isGift, A_index AS rowIndex, IsNull(IsUsingBoxPrice, 0) AS isUsingBoxPrice, \n '' [type], Isnull(fa.Levy, 0) sumTax, fa.selPriceId sellPriceId \n FROM TmpFactart fa \n INNER JOIN M_Group M ON SubString(fa.A_Code, 1, 2) = M.M_GroupCode \n INNER JOIN S_Group S ON M.M_GroupCode = S.M_GroupCode \n   AND SubString(fa.A_Code, 3, 2) = S.S_GroupCode \n LEFT JOIN Unit u ON u.Unit_Code = fa.Unit_Code \n";
        String hloSql = " Union \n SELECT fa.A_Code AS productCode, (S.M_groupcode + S.S_groupcode) AS productGroupCode, \n fa.Fac_Code AS invoiceId, \n Round(Isnull(fa.Few_Article / dbo.IsZero(fa.VahedFew, 1), 0), 0) AS amount, \n IsNull(fa.Price_BS, 0) " + (settingLoader.getSecondUnit() ? "* dbo.IsZero(fa.VahedFew, 1)" : "") + " AS price, \n fa.A_Index AS serverId, fa.FacArtic_Comment AS description, \n isNull(fa.Few_Article2, 0) AS secondAmount, \n isNull(fa.FewBasteh, 0) AS thirdAmount, isNull(fa.VahedCode, -1) AS unitCode, \n isNull(u.Unit_Few, 1) AS coefficient, isNull(fa.DarsadTakhfif, 0) perRowDiscountPercent, \n (CASE WHEN isNull(fa.DarsadTakhfif, 0) > 0 THEN   (isNull(fa.DarsadTakhfif, 0) * (isNull(fa.Few_Article, 0) * isNull(fa.Price_BS, 0))) / 100 \n  else isNull(fa.TakhfifSatriR, 0)  end) perRowDiscountAmount, 0 isGift, \n A_index AS rowIndex, isNull(0, 0) AS isUsingBoxPrice, fa.Fac_Type [type], \n Round(((Levy + Scot) * (isNull(fa.Few_Article, 0) * isNull(fa.Price_BS, 0)  - (CASE WHEN isNull(fa.DarsadTakhfif, 0) > 0 THEN  (isNull(fa.DarsadTakhfif, 0) * (isNull(fa.Few_Article, 0) * isNull(fa.Price_BS, 0))) / 100 \n ELSE isNull(fa.TakhfifSatriR, 0) END))) / 100, 0) sumTax, -1 sellPriceId \n FROM Factart fa \n INNER JOIN Facture f ON f.Fac_Code = fa.Fac_Code AND f.Fac_Type = fa.Fac_Type \n INNER JOIN M_Group M ON SubString(fa.A_Code, 1, 2) = M.M_GroupCode \n INNER JOIN S_Group S ON M.M_GroupCode = S.M_GroupCode \n  AND SubString(fa.A_Code, 3, 2) = S.S_GroupCode \n LEFT JOIN [UNIT] u ON u.Unit_Code = fa.VahedCode \n";
        String aCodes = params.getOrDefault("product-codes", "");
        if (!ConvertStr.isNullOrEmpty((String)aCodes)) {
            aCodes = CollectionBinder.builder().build().wrapThenBind(Arrays.asList(aCodes.split(",")));
        }
        String sql = "SELECT * FROM ( " + select + hloSql + ") a WHERE 1 = 1" + (ConvertStr.isNullOrEmpty((String)aCodes) ? "" : " AND A.productCode IN (" + aCodes + ")") + whereStr + " order by rowIndex, invoiceId, serverId ";
        return this.dbConnection.getJdbcTemplate(login).query(sql, (RowMapper)new DtlMapper(null));
    }

    public FetchAInvoiceDetails(DbConnection dbConnection) {
        this.dbConnection = dbConnection;
    }
}

